#line 1 "C:/Users/Zeb/Desktop/Si5351 SDR Firmware -rev1_16F/Si5351_routines.c"
#line 1 "c:/users/zeb/desktop/si5351 sdr firmware -rev1_16f/si5351sdr.h"
#line 46 "c:/users/zeb/desktop/si5351 sdr firmware -rev1_16f/si5351sdr.h"
extern unsigned long freq;
extern unsigned long StepVal;
extern char LCDText[15];
extern char StepCnt;
extern char ModeCnt;

void si5351aOutputOff (unsigned char);
void si5351aSetFrequency (unsigned long);
void setupPLL (unsigned char, unsigned char, unsigned long, unsigned long);
void setupMultisynth (unsigned char, unsigned long, unsigned char);
void sendRegister (unsigned char, unsigned char);

void SelectMode(void);
unsigned long SelectStep(void);
void DisplayFreq(void);
char Controls();
#line 3 "C:/Users/Zeb/Desktop/Si5351 SDR Firmware -rev1_16F/Si5351_routines.c"
void sendRegister(char reg_addr, char reg_value){
 I2C1_Start();
 I2C1_Wr( 0xC0 );
 I2C1_Wr(reg_addr);
 I2C1_Wr(reg_value);
 I2C1_Stop();
}
void si5351aSetFrequency(unsigned long frequency){
 unsigned divider;
 unsigned long pllFreq;
 unsigned long xtalFreq =  24999117 ;
 unsigned long l;
 float f;
 unsigned char mult;
 unsigned long num;
 unsigned long denom;
 if(frequency < 9050001)divider = 124;
 if(frequency > 9050000)divider = 44;
 pllFreq = divider * frequency;
 mult = pllFreq / xtalFreq;
 l = pllFreq % xtalFreq;
 f = l;
 f *= 1048575;
 f /= xtalFreq;
 num = f;
 denom = 1048575;
 setupPLL( 26 , mult, num, denom);
 setupMultisynth( 42 , divider,  0b00000000 );
 setupMultisynth( 50 , divider,  0b00000000 );
 sendRegister( 165 ,divider);
 sendRegister( 166 , 0);
}

void setupPLL(unsigned char pll, unsigned char mult, unsigned long num, unsigned long denom){
 unsigned long P1;
 unsigned long P2;
 unsigned long P3;

 P1 = (unsigned long)(128 * ((float)num / (float)denom));
 P1 = (unsigned long)(128 * (unsigned long)(mult) + P1 - 512);
 P2 = (unsigned long)(128 * ((float)num / (float)denom));
 P2 = (unsigned long)(128 * num - denom * P2);
 P3 = denom;

 sendRegister(pll + 0, (P3 & 0x0000FF00) >> 8);
 sendRegister(pll + 1, (P3 & 0x000000FF));
 sendRegister(pll + 2, (P1 & 0x00030000) >> 16);
 sendRegister(pll + 3, (P1 & 0x0000FF00) >> 8);
 sendRegister(pll + 4, (P1 & 0x000000FF));
 sendRegister(pll + 5, ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
 sendRegister(pll + 6, (P2 & 0x0000FF00) >> 8);
 sendRegister(pll + 7, (P2 & 0x000000FF));
}

void setupMultisynth(unsigned char synth, unsigned long divider, unsigned char rDiv){
 unsigned long P1;
 unsigned long P2;
 unsigned long P3;
 P1 = 128 * divider - 512;
 P2 = 0;
 P3 = 1;
 sendRegister(synth + 0, (P3 & 0x0000FF00) >> 8);
 sendRegister(synth + 1, (P3 & 0x000000FF));
 sendRegister(synth + 2, ((P1 & 0x00030000) >> 16) | rDiv);
 sendRegister(synth + 3, (P1 & 0x0000FF00) >> 8);
 sendRegister(synth + 4, (P1 & 0x000000FF));
 sendRegister(synth + 5, ((P3 & 0x000F0000) >> 12) | ((P2 & 0x000F0000) >> 16));
 sendRegister(synth + 6, (P2 & 0x0000FF00) >> 8);
 sendRegister(synth + 7, (P2 & 0x000000FF));
}
